/**
 * This class is automatically generated by mig. DO NOT EDIT THIS FILE.
 * This class implements a Java interface to the 'CommandMsg'
 * message type.
 */

package net.tinyos.tinydb;

public class CommandMsg extends net.tinyos.message.Message {

    /** The default size of this message type in bytes. */
    public static final int DEFAULT_MESSAGE_SIZE = 6;

    /** The Active Message type associated with this message. */
    public static final int AM_TYPE = 103;

    /** Create a new CommandMsg of size 6. */
    public CommandMsg() {
        super(DEFAULT_MESSAGE_SIZE);
        amTypeSet(AM_TYPE);
    }

    /** Create a new CommandMsg of the given data_length. */
    public CommandMsg(int data_length) {
        super(data_length);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new CommandMsg with the given data_length
     * and base offset.
     */
    public CommandMsg(int data_length, int base_offset) {
        super(data_length, base_offset);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new CommandMsg using the given byte array
     * as backing store.
     */
    public CommandMsg(byte[] data) {
        super(data);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new CommandMsg using the given byte array
     * as backing store, with the given base offset.
     */
    public CommandMsg(byte[] data, int base_offset) {
        super(data, base_offset);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new CommandMsg using the given byte array
     * as backing store, with the given base offset and data length.
     */
    public CommandMsg(byte[] data, int base_offset, int data_length) {
        super(data, base_offset, data_length);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new CommandMsg embedded in the given message
     * at the given base offset.
     */
    public CommandMsg(net.tinyos.message.Message msg, int base_offset) {
        super(msg, base_offset, DEFAULT_MESSAGE_SIZE);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new CommandMsg embedded in the given message
     * at the given base offset and length.
     */
    public CommandMsg(net.tinyos.message.Message msg, int base_offset, int data_length) {
        super(msg, base_offset, data_length);
        amTypeSet(AM_TYPE);
    }

    /**
    /* Return a String representation of this message. Includes the
     * message type name and the non-indexed field values.
     */
    public String toString() {
      String s = "Message <CommandMsg> \n";
      try {
        s += "  [nodeid=0x"+Long.toHexString(get_nodeid())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
        s += "  [seqNo=0x"+Long.toHexString(get_seqNo())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      return s;
    }

    // Message-type-specific access methods appear below.

    /////////////////////////////////////////////////////////
    // Accessor methods for field: nodeid
    //   Field type: short, signed
    //   Offset (bits): 0
    //   Size (bits): 16
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'nodeid' is signed (true).
     */
    public static boolean isSigned_nodeid() {
        return true;
    }

    /**
     * Return whether the field 'nodeid' is an array (false).
     */
    public static boolean isArray_nodeid() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'nodeid'
     */
    public static int offset_nodeid() {
        return (0 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'nodeid'
     */
    public static int offsetBits_nodeid() {
        return 0;
    }

    /**
     * Return the value (as a short) of the field 'nodeid'
     */
    public short get_nodeid() {
        return (short)getSIntElement(offsetBits_nodeid(), 16);
    }

    /**
     * Set the value of the field 'nodeid'
     */
    public void set_nodeid(short value) {
        setSIntElement(offsetBits_nodeid(), 16, value);
    }

    /**
     * Return the size, in bytes, of the field 'nodeid'
     */
    public static int size_nodeid() {
        return (16 / 8);
    }

    /**
     * Return the size, in bits, of the field 'nodeid'
     */
    public static int sizeBits_nodeid() {
        return 16;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: seqNo
    //   Field type: long, signed
    //   Offset (bits): 16
    //   Size (bits): 32
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'seqNo' is signed (true).
     */
    public static boolean isSigned_seqNo() {
        return true;
    }

    /**
     * Return whether the field 'seqNo' is an array (false).
     */
    public static boolean isArray_seqNo() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'seqNo'
     */
    public static int offset_seqNo() {
        return (16 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'seqNo'
     */
    public static int offsetBits_seqNo() {
        return 16;
    }

    /**
     * Return the value (as a long) of the field 'seqNo'
     */
    public long get_seqNo() {
        return (long)getUIntElement(offsetBits_seqNo(), 32);
    }

    /**
     * Set the value of the field 'seqNo'
     */
    public void set_seqNo(long value) {
        setUIntElement(offsetBits_seqNo(), 32, value);
    }

    /**
     * Return the size, in bytes, of the field 'seqNo'
     */
    public static int size_seqNo() {
        return (32 / 8);
    }

    /**
     * Return the size, in bits, of the field 'seqNo'
     */
    public static int sizeBits_seqNo() {
        return 32;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: data
    //   Field type: byte[], signed
    //   Offset (bits): 48
    //   Size of each element (bits): 8
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'data' is signed (true).
     */
    public static boolean isSigned_data() {
        return true;
    }

    /**
     * Return whether the field 'data' is an array (true).
     */
    public static boolean isArray_data() {
        return true;
    }

    /**
     * Return the offset (in bytes) of the field 'data'
     */
    public static int offset_data(int index1) {
        int offset = 48;
        if (index1 < 0) throw new ArrayIndexOutOfBoundsException();
        offset += 0 + index1 * 8;
        return (offset / 8);
    }

    /**
     * Return the offset (in bits) of the field 'data'
     */
    public static int offsetBits_data(int index1) {
        int offset = 48;
        if (index1 < 0) throw new ArrayIndexOutOfBoundsException();
        offset += 0 + index1 * 8;
        return offset;
    }

    /**
     * Return the entire array 'data' as a byte[]
     */
    public byte[] get_data() {
        throw new IllegalArgumentException("Cannot get field as array - unknown size");
    }

    /**
     * Set the contents of the array 'data' from the given byte[]
     */
    public void set_data(byte[] value) {
        for (int index0 = 0; index0 < value.length; index0++) {
            setElement_data(index0, value[index0]);
        }
    }

    /**
     * Return an element (as a byte) of the array 'data'
     */
    public byte getElement_data(int index1) {
        return (byte)getSIntElement(offsetBits_data(index1), 8);
    }

    /**
     * Set an element of the array 'data'
     */
    public void setElement_data(int index1, byte value) {
        setSIntElement(offsetBits_data(index1), 8, value);
    }

    /**
     * Return the size, in bytes, of each element of the array 'data'
     */
    public static int elementSize_data() {
        return (8 / 8);
    }

    /**
     * Return the size, in bits, of each element of the array 'data'
     */
    public static int elementSizeBits_data() {
        return 8;
    }

    /**
     * Return the number of dimensions in the array 'data'
     */
    public static int numDimensions_data() {
        return 1;
    }

    /**
     * Return the number of elements in the array 'data'
     * for the given dimension.
     */
    public static int numElements_data(int dimension) {
      int array_dims[] = { 0,  };
        if (dimension < 0 || dimension >= 1) throw new ArrayIndexOutOfBoundsException();
        if (array_dims[dimension] == 0) throw new IllegalArgumentException("Array dimension "+dimension+" has unknown size");
        return array_dims[dimension];
    }

    /**
     * Fill in the array 'data' with a String
     */
    public void setString_data(String s) { 
         int len = s.length();
         int i;
         for (i = 0; i < len; i++) {
             setElement_data(i, (byte)s.charAt(i));
         }
         setElement_data(i, (byte)0); //null terminate
    }

    /**
     * Read the array 'data' as a String
     */
    public String getString_data() { 
         char carr[] = new char[net.tinyos.message.Message.MAX_CONVERTED_STRING_LENGTH];
         int i;
         for (i = 0; i < carr.length; i++) {
             if ((char)getElement_data(i) == (char)0) break;
             carr[i] = (char)getElement_data(i);
         }
         return new String(carr,0,i);
    }

}
