/**
 * This class is automatically generated by mig. DO NOT EDIT THIS FILE.
 * This class implements a Java interface to the 'NetworkMsg'
 * message type.
 */

package net.tinyos.tinydb;

public class NetworkMsg extends net.tinyos.message.Message {

    /** The default size of this message type in bytes. */
    public static final int DEFAULT_MESSAGE_SIZE = 8;

    /** The Active Message type associated with this message. */
    public static final int AM_TYPE = -1;

    /** Create a new NetworkMsg of size 8. */
    public NetworkMsg() {
        super(DEFAULT_MESSAGE_SIZE);
        amTypeSet(AM_TYPE);
    }

    /** Create a new NetworkMsg of the given data_length. */
    public NetworkMsg(int data_length) {
        super(data_length);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new NetworkMsg with the given data_length
     * and base offset.
     */
    public NetworkMsg(int data_length, int base_offset) {
        super(data_length, base_offset);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new NetworkMsg using the given byte array
     * as backing store.
     */
    public NetworkMsg(byte[] data) {
        super(data);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new NetworkMsg using the given byte array
     * as backing store, with the given base offset.
     */
    public NetworkMsg(byte[] data, int base_offset) {
        super(data, base_offset);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new NetworkMsg using the given byte array
     * as backing store, with the given base offset and data length.
     */
    public NetworkMsg(byte[] data, int base_offset, int data_length) {
        super(data, base_offset, data_length);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new NetworkMsg embedded in the given message
     * at the given base offset.
     */
    public NetworkMsg(net.tinyos.message.Message msg, int base_offset) {
        super(msg, base_offset, DEFAULT_MESSAGE_SIZE);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new NetworkMsg embedded in the given message
     * at the given base offset and length.
     */
    public NetworkMsg(net.tinyos.message.Message msg, int base_offset, int data_length) {
        super(msg, base_offset, data_length);
        amTypeSet(AM_TYPE);
    }

    /**
    /* Return a String representation of this message. Includes the
     * message type name and the non-indexed field values.
     */
    public String toString() {
      String s = "Message <NetworkMsg> \n";
      try {
        s += "  [hdr.senderid=0x"+Long.toHexString(get_hdr_senderid())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
        s += "  [hdr.parentid=0x"+Long.toHexString(get_hdr_parentid())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
        s += "  [hdr.level=0x"+Long.toHexString(get_hdr_level())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
        s += "  [hdr.timeRemaining=0x"+Long.toHexString(get_hdr_timeRemaining())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
        s += "  [hdr.idx=0x"+Long.toHexString(get_hdr_idx())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      return s;
    }

    // Message-type-specific access methods appear below.

    /////////////////////////////////////////////////////////
    // Accessor methods for field: hdr.senderid
    //   Field type: short, signed
    //   Offset (bits): 0
    //   Size (bits): 16
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'hdr.senderid' is signed (true).
     */
    public static boolean isSigned_hdr_senderid() {
        return true;
    }

    /**
     * Return whether the field 'hdr.senderid' is an array (false).
     */
    public static boolean isArray_hdr_senderid() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'hdr.senderid'
     */
    public static int offset_hdr_senderid() {
        return (0 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'hdr.senderid'
     */
    public static int offsetBits_hdr_senderid() {
        return 0;
    }

    /**
     * Return the value (as a short) of the field 'hdr.senderid'
     */
    public short get_hdr_senderid() {
        return (short)getSIntElement(offsetBits_hdr_senderid(), 16);
    }

    /**
     * Set the value of the field 'hdr.senderid'
     */
    public void set_hdr_senderid(short value) {
        setSIntElement(offsetBits_hdr_senderid(), 16, value);
    }

    /**
     * Return the size, in bytes, of the field 'hdr.senderid'
     */
    public static int size_hdr_senderid() {
        return (16 / 8);
    }

    /**
     * Return the size, in bits, of the field 'hdr.senderid'
     */
    public static int sizeBits_hdr_senderid() {
        return 16;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: hdr.parentid
    //   Field type: short, signed
    //   Offset (bits): 16
    //   Size (bits): 16
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'hdr.parentid' is signed (true).
     */
    public static boolean isSigned_hdr_parentid() {
        return true;
    }

    /**
     * Return whether the field 'hdr.parentid' is an array (false).
     */
    public static boolean isArray_hdr_parentid() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'hdr.parentid'
     */
    public static int offset_hdr_parentid() {
        return (16 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'hdr.parentid'
     */
    public static int offsetBits_hdr_parentid() {
        return 16;
    }

    /**
     * Return the value (as a short) of the field 'hdr.parentid'
     */
    public short get_hdr_parentid() {
        return (short)getSIntElement(offsetBits_hdr_parentid(), 16);
    }

    /**
     * Set the value of the field 'hdr.parentid'
     */
    public void set_hdr_parentid(short value) {
        setSIntElement(offsetBits_hdr_parentid(), 16, value);
    }

    /**
     * Return the size, in bytes, of the field 'hdr.parentid'
     */
    public static int size_hdr_parentid() {
        return (16 / 8);
    }

    /**
     * Return the size, in bits, of the field 'hdr.parentid'
     */
    public static int sizeBits_hdr_parentid() {
        return 16;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: hdr.level
    //   Field type: short, signed
    //   Offset (bits): 32
    //   Size (bits): 8
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'hdr.level' is signed (true).
     */
    public static boolean isSigned_hdr_level() {
        return true;
    }

    /**
     * Return whether the field 'hdr.level' is an array (false).
     */
    public static boolean isArray_hdr_level() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'hdr.level'
     */
    public static int offset_hdr_level() {
        return (32 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'hdr.level'
     */
    public static int offsetBits_hdr_level() {
        return 32;
    }

    /**
     * Return the value (as a short) of the field 'hdr.level'
     */
    public short get_hdr_level() {
        return (short)getUIntElement(offsetBits_hdr_level(), 8);
    }

    /**
     * Set the value of the field 'hdr.level'
     */
    public void set_hdr_level(short value) {
        setUIntElement(offsetBits_hdr_level(), 8, value);
    }

    /**
     * Return the size, in bytes, of the field 'hdr.level'
     */
    public static int size_hdr_level() {
        return (8 / 8);
    }

    /**
     * Return the size, in bits, of the field 'hdr.level'
     */
    public static int sizeBits_hdr_level() {
        return 8;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: hdr.timeRemaining
    //   Field type: short, signed
    //   Offset (bits): 40
    //   Size (bits): 8
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'hdr.timeRemaining' is signed (true).
     */
    public static boolean isSigned_hdr_timeRemaining() {
        return true;
    }

    /**
     * Return whether the field 'hdr.timeRemaining' is an array (false).
     */
    public static boolean isArray_hdr_timeRemaining() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'hdr.timeRemaining'
     */
    public static int offset_hdr_timeRemaining() {
        return (40 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'hdr.timeRemaining'
     */
    public static int offsetBits_hdr_timeRemaining() {
        return 40;
    }

    /**
     * Return the value (as a short) of the field 'hdr.timeRemaining'
     */
    public short get_hdr_timeRemaining() {
        return (short)getUIntElement(offsetBits_hdr_timeRemaining(), 8);
    }

    /**
     * Set the value of the field 'hdr.timeRemaining'
     */
    public void set_hdr_timeRemaining(short value) {
        setUIntElement(offsetBits_hdr_timeRemaining(), 8, value);
    }

    /**
     * Return the size, in bytes, of the field 'hdr.timeRemaining'
     */
    public static int size_hdr_timeRemaining() {
        return (8 / 8);
    }

    /**
     * Return the size, in bits, of the field 'hdr.timeRemaining'
     */
    public static int sizeBits_hdr_timeRemaining() {
        return 8;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: hdr.idx
    //   Field type: short, signed
    //   Offset (bits): 48
    //   Size (bits): 8
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'hdr.idx' is signed (true).
     */
    public static boolean isSigned_hdr_idx() {
        return true;
    }

    /**
     * Return whether the field 'hdr.idx' is an array (false).
     */
    public static boolean isArray_hdr_idx() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'hdr.idx'
     */
    public static int offset_hdr_idx() {
        return (48 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'hdr.idx'
     */
    public static int offsetBits_hdr_idx() {
        return 48;
    }

    /**
     * Return the value (as a short) of the field 'hdr.idx'
     */
    public short get_hdr_idx() {
        return (short)getUIntElement(offsetBits_hdr_idx(), 8);
    }

    /**
     * Set the value of the field 'hdr.idx'
     */
    public void set_hdr_idx(short value) {
        setUIntElement(offsetBits_hdr_idx(), 8, value);
    }

    /**
     * Return the size, in bytes, of the field 'hdr.idx'
     */
    public static int size_hdr_idx() {
        return (8 / 8);
    }

    /**
     * Return the size, in bits, of the field 'hdr.idx'
     */
    public static int sizeBits_hdr_idx() {
        return 8;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: data
    //   Field type: byte[], signed
    //   Offset (bits): 64
    //   Size of each element (bits): 8
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'data' is signed (true).
     */
    public static boolean isSigned_data() {
        return true;
    }

    /**
     * Return whether the field 'data' is an array (true).
     */
    public static boolean isArray_data() {
        return true;
    }

    /**
     * Return the offset (in bytes) of the field 'data'
     */
    public static int offset_data(int index1) {
        int offset = 64;
        if (index1 < 0) throw new ArrayIndexOutOfBoundsException();
        offset += 0 + index1 * 8;
        return (offset / 8);
    }

    /**
     * Return the offset (in bits) of the field 'data'
     */
    public static int offsetBits_data(int index1) {
        int offset = 64;
        if (index1 < 0) throw new ArrayIndexOutOfBoundsException();
        offset += 0 + index1 * 8;
        return offset;
    }

    /**
     * Return the entire array 'data' as a byte[]
     */
    public byte[] get_data() {
        throw new IllegalArgumentException("Cannot get field as array - unknown size");
    }

    /**
     * Set the contents of the array 'data' from the given byte[]
     */
    public void set_data(byte[] value) {
        for (int index0 = 0; index0 < value.length; index0++) {
            setElement_data(index0, value[index0]);
        }
    }

    /**
     * Return an element (as a byte) of the array 'data'
     */
    public byte getElement_data(int index1) {
        return (byte)getSIntElement(offsetBits_data(index1), 8);
    }

    /**
     * Set an element of the array 'data'
     */
    public void setElement_data(int index1, byte value) {
        setSIntElement(offsetBits_data(index1), 8, value);
    }

    /**
     * Return the size, in bytes, of each element of the array 'data'
     */
    public static int elementSize_data() {
        return (8 / 8);
    }

    /**
     * Return the size, in bits, of each element of the array 'data'
     */
    public static int elementSizeBits_data() {
        return 8;
    }

    /**
     * Return the number of dimensions in the array 'data'
     */
    public static int numDimensions_data() {
        return 1;
    }

    /**
     * Return the number of elements in the array 'data'
     * for the given dimension.
     */
    public static int numElements_data(int dimension) {
      int array_dims[] = { 0,  };
        if (dimension < 0 || dimension >= 1) throw new ArrayIndexOutOfBoundsException();
        if (array_dims[dimension] == 0) throw new IllegalArgumentException("Array dimension "+dimension+" has unknown size");
        return array_dims[dimension];
    }

    /**
     * Fill in the array 'data' with a String
     */
    public void setString_data(String s) { 
         int len = s.length();
         int i;
         for (i = 0; i < len; i++) {
             setElement_data(i, (byte)s.charAt(i));
         }
         setElement_data(i, (byte)0); //null terminate
    }

    /**
     * Read the array 'data' as a String
     */
    public String getString_data() { 
         char carr[] = new char[net.tinyos.message.Message.MAX_CONVERTED_STRING_LENGTH];
         int i;
         for (i = 0; i < carr.length; i++) {
             if ((char)getElement_data(i) == (char)0) break;
             carr[i] = (char)getElement_data(i);
         }
         return new String(carr,0,i);
    }

}
