/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */
package net.tinyos.tinydb.parser;
//import sym.*;
import java_cup.runtime.*;
/* semantic value of token returned by scanner */
class TokenValue {
  public int lineBegin;
  public int charBegin;
  public String text;
  public String filename;
  TokenValue() {
  }
  TokenValue(String text, int lineBegin, int charBegin, String filename) {
    this.text = text;
    this.lineBegin = lineBegin;
    this.charBegin = charBegin;
    this.filename = filename;
  }
  public String toString() {
    return text;
  }
  public boolean toBoolean() {
    return Boolean.valueOf(text).booleanValue();
  }
  public int toInt() {
    return Integer.valueOf(text).intValue();
  }
}


class Yylex implements java_cup.runtime.Scanner {
	private final int YY_BUFFER_SIZE = 512;
	private final int YY_F = -1;
	private final int YY_NO_STATE = -1;
	private final int YY_NOT_ACCEPT = 0;
	private final int YY_START = 1;
	private final int YY_END = 2;
	private final int YY_NO_ANCHOR = 4;
	private final int YY_BOL = 128;
	private final int YY_EOF = 129;

  public String sourceFilename;
	private java.io.BufferedReader yy_reader;
	private int yy_buffer_index;
	private int yy_buffer_read;
	private int yy_buffer_start;
	private int yy_buffer_end;
	private char yy_buffer[];
	private int yychar;
	private int yyline;
	private boolean yy_at_bol;
	private int yy_lexical_state;

	Yylex (java.io.Reader reader) {
		this ();
		if (null == reader) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(reader);
	}

	Yylex (java.io.InputStream instream) {
		this ();
		if (null == instream) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(new java.io.InputStreamReader(instream));
	}

	private Yylex () {
		yy_buffer = new char[YY_BUFFER_SIZE];
		yy_buffer_read = 0;
		yy_buffer_index = 0;
		yy_buffer_start = 0;
		yy_buffer_end = 0;
		yychar = 0;
		yyline = 0;
		yy_at_bol = true;
		yy_lexical_state = YYINITIAL;
	}

	private boolean yy_eof_done = false;
	private final int YYINITIAL = 0;
	private final int COMMENTS = 1;
	private final int yy_state_dtrans[] = {
		0,
		129
	};
	private void yybegin (int state) {
		yy_lexical_state = state;
	}
	private int yy_advance ()
		throws java.io.IOException {
		int next_read;
		int i;
		int j;

		if (yy_buffer_index < yy_buffer_read) {
			return yy_buffer[yy_buffer_index++];
		}

		if (0 != yy_buffer_start) {
			i = yy_buffer_start;
			j = 0;
			while (i < yy_buffer_read) {
				yy_buffer[j] = yy_buffer[i];
				++i;
				++j;
			}
			yy_buffer_end = yy_buffer_end - yy_buffer_start;
			yy_buffer_start = 0;
			yy_buffer_read = j;
			yy_buffer_index = j;
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}

		while (yy_buffer_index >= yy_buffer_read) {
			if (yy_buffer_index >= yy_buffer.length) {
				yy_buffer = yy_double(yy_buffer);
			}
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}
		return yy_buffer[yy_buffer_index++];
	}
	private void yy_move_end () {
		if (yy_buffer_end > yy_buffer_start &&
		    '\n' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
		if (yy_buffer_end > yy_buffer_start &&
		    '\r' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
	}
	private boolean yy_last_was_cr=false;
	private void yy_mark_start () {
		int i;
		for (i = yy_buffer_start; i < yy_buffer_index; ++i) {
			if ('\n' == yy_buffer[i] && !yy_last_was_cr) {
				++yyline;
			}
			if ('\r' == yy_buffer[i]) {
				++yyline;
				yy_last_was_cr=true;
			} else yy_last_was_cr=false;
		}
		yychar = yychar
			+ yy_buffer_index - yy_buffer_start;
		yy_buffer_start = yy_buffer_index;
	}
	private void yy_mark_end () {
		yy_buffer_end = yy_buffer_index;
	}
	private void yy_to_mark () {
		yy_buffer_index = yy_buffer_end;
		yy_at_bol = (yy_buffer_end > yy_buffer_start) &&
		            ('\r' == yy_buffer[yy_buffer_end-1] ||
		             '\n' == yy_buffer[yy_buffer_end-1] ||
		             2028/*LS*/ == yy_buffer[yy_buffer_end-1] ||
		             2029/*PS*/ == yy_buffer[yy_buffer_end-1]);
	}
	private java.lang.String yytext () {
		return (new java.lang.String(yy_buffer,
			yy_buffer_start,
			yy_buffer_end - yy_buffer_start));
	}
	private int yylength () {
		return yy_buffer_end - yy_buffer_start;
	}
	private char[] yy_double (char buf[]) {
		int i;
		char newbuf[];
		newbuf = new char[2*buf.length];
		for (i = 0; i < buf.length; ++i) {
			newbuf[i] = buf[i];
		}
		return newbuf;
	}
	private final int YY_E_INTERNAL = 0;
	private final int YY_E_MATCH = 1;
	private java.lang.String yy_error_string[] = {
		"Error: Internal error.\n",
		"Error: Unmatched input.\n"
	};
	private void yy_error (int code,boolean fatal) {
		java.lang.System.out.print(yy_error_string[code]);
		java.lang.System.out.flush();
		if (fatal) {
			throw new Error("Fatal Error.\n");
		}
	}
	private int[][] unpackFromString(int size1, int size2, String st) {
		int colonIndex = -1;
		String lengthString;
		int sequenceLength = 0;
		int sequenceInteger = 0;

		int commaIndex;
		String workString;

		int res[][] = new int[size1][size2];
		for (int i= 0; i < size1; i++) {
			for (int j= 0; j < size2; j++) {
				if (sequenceLength != 0) {
					res[i][j] = sequenceInteger;
					sequenceLength--;
					continue;
				}
				commaIndex = st.indexOf(',');
				workString = (commaIndex==-1) ? st :
					st.substring(0, commaIndex);
				st = st.substring(commaIndex+1);
				colonIndex = workString.indexOf(':');
				if (colonIndex == -1) {
					res[i][j]=Integer.parseInt(workString);
					continue;
				}
				lengthString =
					workString.substring(colonIndex+1);
				sequenceLength=Integer.parseInt(lengthString);
				workString=workString.substring(0,colonIndex);
				sequenceInteger=Integer.parseInt(workString);
				res[i][j] = sequenceInteger;
				sequenceLength--;
			}
		}
		return res;
	}
	private int yy_acpt[] = {
		/* 0 */ YY_NOT_ACCEPT,
		/* 1 */ YY_NO_ANCHOR,
		/* 2 */ YY_NO_ANCHOR,
		/* 3 */ YY_NO_ANCHOR,
		/* 4 */ YY_NO_ANCHOR,
		/* 5 */ YY_NO_ANCHOR,
		/* 6 */ YY_NO_ANCHOR,
		/* 7 */ YY_NO_ANCHOR,
		/* 8 */ YY_NO_ANCHOR,
		/* 9 */ YY_NO_ANCHOR,
		/* 10 */ YY_NO_ANCHOR,
		/* 11 */ YY_NO_ANCHOR,
		/* 12 */ YY_NO_ANCHOR,
		/* 13 */ YY_NO_ANCHOR,
		/* 14 */ YY_NO_ANCHOR,
		/* 15 */ YY_NO_ANCHOR,
		/* 16 */ YY_NO_ANCHOR,
		/* 17 */ YY_NO_ANCHOR,
		/* 18 */ YY_NO_ANCHOR,
		/* 19 */ YY_NO_ANCHOR,
		/* 20 */ YY_NO_ANCHOR,
		/* 21 */ YY_NO_ANCHOR,
		/* 22 */ YY_NO_ANCHOR,
		/* 23 */ YY_NO_ANCHOR,
		/* 24 */ YY_NO_ANCHOR,
		/* 25 */ YY_NO_ANCHOR,
		/* 26 */ YY_NO_ANCHOR,
		/* 27 */ YY_NO_ANCHOR,
		/* 28 */ YY_NO_ANCHOR,
		/* 29 */ YY_NO_ANCHOR,
		/* 30 */ YY_NO_ANCHOR,
		/* 31 */ YY_NO_ANCHOR,
		/* 32 */ YY_NO_ANCHOR,
		/* 33 */ YY_NO_ANCHOR,
		/* 34 */ YY_NO_ANCHOR,
		/* 35 */ YY_NO_ANCHOR,
		/* 36 */ YY_NO_ANCHOR,
		/* 37 */ YY_NO_ANCHOR,
		/* 38 */ YY_NO_ANCHOR,
		/* 39 */ YY_NO_ANCHOR,
		/* 40 */ YY_NOT_ACCEPT,
		/* 41 */ YY_NO_ANCHOR,
		/* 42 */ YY_NO_ANCHOR,
		/* 43 */ YY_NOT_ACCEPT,
		/* 44 */ YY_NO_ANCHOR,
		/* 45 */ YY_NOT_ACCEPT,
		/* 46 */ YY_NO_ANCHOR,
		/* 47 */ YY_NOT_ACCEPT,
		/* 48 */ YY_NO_ANCHOR,
		/* 49 */ YY_NOT_ACCEPT,
		/* 50 */ YY_NO_ANCHOR,
		/* 51 */ YY_NOT_ACCEPT,
		/* 52 */ YY_NO_ANCHOR,
		/* 53 */ YY_NOT_ACCEPT,
		/* 54 */ YY_NO_ANCHOR,
		/* 55 */ YY_NOT_ACCEPT,
		/* 56 */ YY_NO_ANCHOR,
		/* 57 */ YY_NOT_ACCEPT,
		/* 58 */ YY_NO_ANCHOR,
		/* 59 */ YY_NOT_ACCEPT,
		/* 60 */ YY_NO_ANCHOR,
		/* 61 */ YY_NOT_ACCEPT,
		/* 62 */ YY_NO_ANCHOR,
		/* 63 */ YY_NOT_ACCEPT,
		/* 64 */ YY_NO_ANCHOR,
		/* 65 */ YY_NOT_ACCEPT,
		/* 66 */ YY_NO_ANCHOR,
		/* 67 */ YY_NOT_ACCEPT,
		/* 68 */ YY_NO_ANCHOR,
		/* 69 */ YY_NOT_ACCEPT,
		/* 70 */ YY_NO_ANCHOR,
		/* 71 */ YY_NOT_ACCEPT,
		/* 72 */ YY_NO_ANCHOR,
		/* 73 */ YY_NOT_ACCEPT,
		/* 74 */ YY_NO_ANCHOR,
		/* 75 */ YY_NOT_ACCEPT,
		/* 76 */ YY_NO_ANCHOR,
		/* 77 */ YY_NOT_ACCEPT,
		/* 78 */ YY_NO_ANCHOR,
		/* 79 */ YY_NOT_ACCEPT,
		/* 80 */ YY_NO_ANCHOR,
		/* 81 */ YY_NOT_ACCEPT,
		/* 82 */ YY_NO_ANCHOR,
		/* 83 */ YY_NOT_ACCEPT,
		/* 84 */ YY_NO_ANCHOR,
		/* 85 */ YY_NOT_ACCEPT,
		/* 86 */ YY_NO_ANCHOR,
		/* 87 */ YY_NOT_ACCEPT,
		/* 88 */ YY_NO_ANCHOR,
		/* 89 */ YY_NOT_ACCEPT,
		/* 90 */ YY_NO_ANCHOR,
		/* 91 */ YY_NOT_ACCEPT,
		/* 92 */ YY_NO_ANCHOR,
		/* 93 */ YY_NOT_ACCEPT,
		/* 94 */ YY_NO_ANCHOR,
		/* 95 */ YY_NOT_ACCEPT,
		/* 96 */ YY_NO_ANCHOR,
		/* 97 */ YY_NOT_ACCEPT,
		/* 98 */ YY_NO_ANCHOR,
		/* 99 */ YY_NOT_ACCEPT,
		/* 100 */ YY_NO_ANCHOR,
		/* 101 */ YY_NOT_ACCEPT,
		/* 102 */ YY_NO_ANCHOR,
		/* 103 */ YY_NOT_ACCEPT,
		/* 104 */ YY_NO_ANCHOR,
		/* 105 */ YY_NOT_ACCEPT,
		/* 106 */ YY_NO_ANCHOR,
		/* 107 */ YY_NOT_ACCEPT,
		/* 108 */ YY_NO_ANCHOR,
		/* 109 */ YY_NOT_ACCEPT,
		/* 110 */ YY_NO_ANCHOR,
		/* 111 */ YY_NOT_ACCEPT,
		/* 112 */ YY_NO_ANCHOR,
		/* 113 */ YY_NOT_ACCEPT,
		/* 114 */ YY_NO_ANCHOR,
		/* 115 */ YY_NOT_ACCEPT,
		/* 116 */ YY_NO_ANCHOR,
		/* 117 */ YY_NOT_ACCEPT,
		/* 118 */ YY_NO_ANCHOR,
		/* 119 */ YY_NOT_ACCEPT,
		/* 120 */ YY_NO_ANCHOR,
		/* 121 */ YY_NOT_ACCEPT,
		/* 122 */ YY_NO_ANCHOR,
		/* 123 */ YY_NOT_ACCEPT,
		/* 124 */ YY_NOT_ACCEPT,
		/* 125 */ YY_NOT_ACCEPT,
		/* 126 */ YY_NOT_ACCEPT,
		/* 127 */ YY_NOT_ACCEPT,
		/* 128 */ YY_NOT_ACCEPT,
		/* 129 */ YY_NOT_ACCEPT,
		/* 130 */ YY_NO_ANCHOR,
		/* 131 */ YY_NOT_ACCEPT,
		/* 132 */ YY_NOT_ACCEPT,
		/* 133 */ YY_NOT_ACCEPT,
		/* 134 */ YY_NOT_ACCEPT,
		/* 135 */ YY_NO_ANCHOR,
		/* 136 */ YY_NO_ANCHOR,
		/* 137 */ YY_NO_ANCHOR,
		/* 138 */ YY_NO_ANCHOR,
		/* 139 */ YY_NO_ANCHOR,
		/* 140 */ YY_NO_ANCHOR,
		/* 141 */ YY_NO_ANCHOR,
		/* 142 */ YY_NO_ANCHOR,
		/* 143 */ YY_NO_ANCHOR,
		/* 144 */ YY_NO_ANCHOR,
		/* 145 */ YY_NO_ANCHOR,
		/* 146 */ YY_NO_ANCHOR,
		/* 147 */ YY_NO_ANCHOR,
		/* 148 */ YY_NO_ANCHOR,
		/* 149 */ YY_NO_ANCHOR,
		/* 150 */ YY_NO_ANCHOR,
		/* 151 */ YY_NO_ANCHOR,
		/* 152 */ YY_NO_ANCHOR,
		/* 153 */ YY_NO_ANCHOR,
		/* 154 */ YY_NO_ANCHOR,
		/* 155 */ YY_NO_ANCHOR,
		/* 156 */ YY_NO_ANCHOR,
		/* 157 */ YY_NO_ANCHOR,
		/* 158 */ YY_NO_ANCHOR,
		/* 159 */ YY_NO_ANCHOR,
		/* 160 */ YY_NO_ANCHOR,
		/* 161 */ YY_NO_ANCHOR,
		/* 162 */ YY_NO_ANCHOR,
		/* 163 */ YY_NO_ANCHOR,
		/* 164 */ YY_NO_ANCHOR,
		/* 165 */ YY_NO_ANCHOR,
		/* 166 */ YY_NO_ANCHOR,
		/* 167 */ YY_NO_ANCHOR,
		/* 168 */ YY_NO_ANCHOR,
		/* 169 */ YY_NO_ANCHOR,
		/* 170 */ YY_NO_ANCHOR,
		/* 171 */ YY_NO_ANCHOR,
		/* 172 */ YY_NO_ANCHOR,
		/* 173 */ YY_NO_ANCHOR,
		/* 174 */ YY_NO_ANCHOR,
		/* 175 */ YY_NO_ANCHOR,
		/* 176 */ YY_NO_ANCHOR,
		/* 177 */ YY_NO_ANCHOR,
		/* 178 */ YY_NO_ANCHOR,
		/* 179 */ YY_NO_ANCHOR,
		/* 180 */ YY_NO_ANCHOR,
		/* 181 */ YY_NO_ANCHOR,
		/* 182 */ YY_NO_ANCHOR,
		/* 183 */ YY_NO_ANCHOR,
		/* 184 */ YY_NO_ANCHOR,
		/* 185 */ YY_NO_ANCHOR,
		/* 186 */ YY_NO_ANCHOR,
		/* 187 */ YY_NO_ANCHOR,
		/* 188 */ YY_NO_ANCHOR,
		/* 189 */ YY_NO_ANCHOR,
		/* 190 */ YY_NO_ANCHOR,
		/* 191 */ YY_NO_ANCHOR,
		/* 192 */ YY_NO_ANCHOR,
		/* 193 */ YY_NO_ANCHOR,
		/* 194 */ YY_NO_ANCHOR,
		/* 195 */ YY_NO_ANCHOR,
		/* 196 */ YY_NO_ANCHOR,
		/* 197 */ YY_NO_ANCHOR,
		/* 198 */ YY_NO_ANCHOR,
		/* 199 */ YY_NO_ANCHOR,
		/* 200 */ YY_NO_ANCHOR,
		/* 201 */ YY_NO_ANCHOR,
		/* 202 */ YY_NO_ANCHOR,
		/* 203 */ YY_NO_ANCHOR,
		/* 204 */ YY_NO_ANCHOR,
		/* 205 */ YY_NO_ANCHOR,
		/* 206 */ YY_NO_ANCHOR,
		/* 207 */ YY_NO_ANCHOR,
		/* 208 */ YY_NO_ANCHOR,
		/* 209 */ YY_NO_ANCHOR,
		/* 210 */ YY_NO_ANCHOR,
		/* 211 */ YY_NO_ANCHOR,
		/* 212 */ YY_NO_ANCHOR,
		/* 213 */ YY_NO_ANCHOR,
		/* 214 */ YY_NO_ANCHOR,
		/* 215 */ YY_NO_ANCHOR,
		/* 216 */ YY_NO_ANCHOR,
		/* 217 */ YY_NO_ANCHOR,
		/* 218 */ YY_NO_ANCHOR,
		/* 219 */ YY_NO_ANCHOR,
		/* 220 */ YY_NO_ANCHOR,
		/* 221 */ YY_NO_ANCHOR,
		/* 222 */ YY_NO_ANCHOR,
		/* 223 */ YY_NO_ANCHOR,
		/* 224 */ YY_NO_ANCHOR,
		/* 225 */ YY_NO_ANCHOR,
		/* 226 */ YY_NO_ANCHOR,
		/* 227 */ YY_NO_ANCHOR,
		/* 228 */ YY_NO_ANCHOR,
		/* 229 */ YY_NO_ANCHOR,
		/* 230 */ YY_NO_ANCHOR,
		/* 231 */ YY_NO_ANCHOR,
		/* 232 */ YY_NO_ANCHOR,
		/* 233 */ YY_NO_ANCHOR,
		/* 234 */ YY_NO_ANCHOR,
		/* 235 */ YY_NO_ANCHOR,
		/* 236 */ YY_NO_ANCHOR,
		/* 237 */ YY_NO_ANCHOR,
		/* 238 */ YY_NO_ANCHOR,
		/* 239 */ YY_NO_ANCHOR,
		/* 240 */ YY_NO_ANCHOR,
		/* 241 */ YY_NO_ANCHOR,
		/* 242 */ YY_NO_ANCHOR,
		/* 243 */ YY_NO_ANCHOR,
		/* 244 */ YY_NO_ANCHOR,
		/* 245 */ YY_NO_ANCHOR,
		/* 246 */ YY_NO_ANCHOR
	};
	private int yy_cmap[] = unpackFromString(1,130,
"61:9,62,60,61,62:2,61:18,42,61:4,51,61:2,50,37,51:2,48,51,47,52,39:10,49,61" +
",35,36,38,61:2,21,43,29,23,3,9,40,2,53,59:2,28,11,22,10,41,15,4,27,30,16,55" +
",1,59,17,57,61:4,59,61,24,46,33,26,7,12,44,6,54,59:2,32,14,25,13,45,18,8,31" +
",34,19,56,5,59,20,58,61:5,0:2")[0];

	private int yy_rmap[] = unpackFromString(1,247,
"0,1,2,3,1:2,4,5,6,1:6,7:2,1:4,7:12,1:7,8,9,10,11,12,13,14,15,16,17,18,19,20" +
",21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45" +
",46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70" +
",71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,79,94" +
",81,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113," +
"114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132" +
",133,134,135,136,137,138,139,7,140,141,142,143,144,145,146,147,148,149,150," +
"151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169" +
",170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,7," +
"188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206" +
",207,208,209,210")[0];

	private int yy_nxt[][] = unpackFromString(211,63,
"1,2,223,230,223,231,223,232,223,130,41,223,137,44,223,233,223:2,234,223:2,4" +
"6,223,235,48,223,236,169,223,237,238,170,223,239,240,3,4,5,6,7,241,242,8,24" +
"3,244,245,246,9,10,11,12,13,42,171,172,223:5,8,14,8,-1:64,223,173,223:32,-1" +
":4,174,223:2,-1,223:4,-1:6,223:7,-1:39,17,-1,18,-1:60,19,-1,13,-1:63,7,-1:6" +
"5,8,-1:17,8,-1,8,-1,223:34,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:6,45,-1:60" +
",223:3,15,223:11,178,223:5,52,223:12,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:" +
"55,20,-1:17,47,-1:56,223:7,15,223:10,179,223:5,56,223:9,-1:4,174,223:2,-1,2" +
"23:4,-1:6,223:7,-1:58,49,-1:8,223:21,58,223:4,16,223:7,-1:4,174,223:2,-1,22" +
"3:4,-1:6,223:7,-1:59,51,-1:7,223:24,60,223:5,16,223:3,-1:4,174,223:2,-1,223" +
":4,-1:6,223:7,-1:6,55,-1:60,223:3,21,223:30,-1:4,174,223:2,-1,223:4,-1:6,22" +
"3:7,-1:10,57,-1:56,223:28,64,223:5,-1:4,174,223:2,40,223:4,-1:6,223:7,-1:24" +
",59,-1:42,223:7,21,223:26,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:25,67,-1:41" +
",223:32,68,223,-1:4,174,223:2,43,223:4,-1:6,223:7,-1:28,71,-1:38,223:22,22," +
"223:11,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:31,73,-1:35,223:25,22,223:8,-1" +
":4,174,223:2,-1,223:4,-1:6,223:7,-1:46,75,-1:20,223:10,23,223:23,-1:4,174,2" +
"23:2,-1,223:4,-1:6,223:7,-1:49,77,-1:17,223:2,24,223:31,-1:4,174,223:2,-1,2" +
"23:4,-1:6,223:7,-1:24,79,-1:42,223:13,23,223:20,-1:4,174,223:2,-1,223:4,-1:" +
"6,223:7,-1:33,33,-1:33,223:6,24,223:27,-1:4,174,223:2,-1,223:4,-1:6,223:7,-" +
"1:27,81,-1:39,223:2,25,223:31,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:37,33,-" +
"1:29,223:6,25,223:27,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:31,34,-1:35,223:" +
"9,26,223:24,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:20,35,-1:46,223:12,26,223" +
":21,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:23,35,-1:43,223:2,27,223:31,-1:4," +
"174,223:2,-1,223:4,-1:6,223:7,-1:32,91,-1:34,223,28,223:32,-1:4,174,223:2,-" +
"1,223:4,-1:6,223:7,-1:36,93,-1:30,223:6,27,223:27,-1:4,174,223:2,-1,223:4,-" +
"1:6,223:7,-1:19,95,-1:47,223:5,28,223:28,-1:4,174,223:2,-1,223:4,-1:6,223:7" +
",-1:24,97,-1:42,223:16,29,223:17,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:22,9" +
"9,-1:44,223:19,29,223:14,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:27,101,-1:39" +
",223:34,-1:4,174,223:2,53,223:4,-1:6,223:7,-1:33,103,-1:33,223:29,30,223:4," +
"-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:37,105,-1:29,223:2,28,223:31,-1:4,174" +
",223:2,-1,223:4,-1:6,223:7,-1:12,133,-1:54,223:33,30,-1:4,174,223:2,-1,223:" +
"4,-1:6,223:7,-1:32,107,-1:34,223:6,28,223:27,-1:4,174,223:2,-1,223:4,-1:6,2" +
"23:7,-1:15,134,-1:51,223:34,-1:4,174,223:2,61,223:4,-1:6,223:7,-1:36,109,-1" +
":30,223:22,31,223:11,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:56,111,-1:10,223" +
":3,32,223:30,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:57,113,-1:9,223:34,-1:4," +
"174,223:2,63,223:4,-1:6,223:7,-1:33,117,-1:33,223:25,31,223:8,-1:4,174,223:" +
"2,-1,223:4,-1:6,223:7,-1:37,121,-1:29,223:7,32,223:26,-1:4,174,223:2,-1,223" +
":4,-1:6,223:7,-1:13,123,-1:53,223:34,-1:4,174,223:2,65,223:4,-1:6,223:7,-1:" +
"16,124,-1:50,223:34,-1:4,174,223:2,69,223:4,-1:6,223:7,-1:6,125,-1:60,223:2" +
"1,31,223:12,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:56,126,-1:10,223:24,31,22" +
"3:9,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:10,127,-1:56,223:34,-1:4,174,223:" +
"2,85,223:4,-1:6,223:7,-1:57,128,-1:9,223:34,-1:4,174,223:2,89,223:4,-1:6,22" +
"3:7,-1:25,36,-1:65,36,-1:41,37,-1:66,37,-1:54,1,38:59,39,38:2,-1,223:3,138," +
"223:5,50,223:24,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:46,83,-1:65,87,-1:25," +
"115,-1:65,119,-1:51,223:34,-1:4,174,223:2,131,223:4,-1:6,223:7,-1:4,223:34," +
"-1:4,174,223:2,132,223:4,-1:6,223:7,-1:4,223:7,139,223:4,54,223:21,-1:4,174" +
",223:2,-1,223:4,-1:6,223:7,-1:4,223:9,62,223:24,-1:4,174,223:2,-1,223:4,-1:" +
"6,223:7,-1:4,223:12,66,223:21,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:3" +
"4,-1:4,174,223:2,-1,223:4,-1:6,223:4,70,223:2,-1:4,223:34,-1:4,174,223:2,-1" +
",223:4,-1:6,223:5,72,223,-1:4,223:29,74,223:4,-1:4,174,223:2,-1,223:4,-1:6," +
"223:7,-1:4,223:33,76,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:3,78,223:3" +
"0,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:28,80,223:5,-1:4,174,223:2,-1" +
",223:4,-1:6,223:7,-1:4,223:7,82,223:26,-1:4,174,223:2,-1,223:4,-1:6,223:7,-" +
"1:4,223:32,84,223,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:3,86,223:30,-" +
"1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:7,88,223:26,-1:4,174,223:2,-1,22" +
"3:4,-1:6,223:7,-1:4,223:34,-1:4,174,223,90,-1,223:4,-1:6,223:7,-1:4,223:28," +
"92,223:5,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:27,94,223:6,-1:4,174,2" +
"23:2,-1,223:4,-1:6,223:7,-1:4,223:32,96,223,-1:4,174,223:2,-1,223:4,-1:6,22" +
"3:7,-1:4,223:31,98,223:2,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:34,-1:" +
"4,174,223,100,-1,223:4,-1:6,223:7,-1:4,223:9,102,223:24,-1:4,174,223:2,-1,2" +
"23:4,-1:6,223:7,-1:4,223:2,104,223:31,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1" +
":4,223:34,-1:4,174,223:2,-1,223:2,106,223,-1:6,223:7,-1:4,223:12,108,223:21" +
",-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:6,110,223:27,-1:4,174,223:2,-1" +
",223:4,-1:6,223:7,-1:4,223:29,112,223:4,-1:4,174,223:2,-1,223:4,-1:6,223:7," +
"-1:4,223:33,114,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:2,135,223:31,-1" +
":4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:6,136,223:27,-1:4,174,223:2,-1,22" +
"3:4,-1:6,223:7,-1:4,223:9,116,223:24,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:" +
"4,223:12,118,223:21,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:3,120,223:3" +
"0,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:7,122,223:26,-1:4,174,223:2,-" +
"1,223:4,-1:6,223:7,-1:4,223:2,185,223:17,186,223:13,-1:4,174,223:2,-1,223:4" +
",-1:6,140,223:6,-1:4,223:6,189,223:16,190,223:10,-1:4,174,223:2,-1,223:4,-1" +
":6,223,141,223:5,-1:4,223:21,142,223:12,-1:4,174,223:2,-1,223:4,-1:6,223:7," +
"-1:4,223:24,143,223:9,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:2,144,223" +
":31,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:9,145,223:24,-1:4,174,223:2" +
",-1,223:4,-1:6,223:7,-1:4,223:6,146,223:27,-1:4,174,223:2,-1,223:4,-1:6,223" +
":7,-1:4,223:12,147,223:21,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:29,19" +
"7,223:4,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:33,198,-1:4,174,223:2,-" +
"1,223:4,-1:6,223:7,-1:4,223:2,148,223:31,-1:4,174,223:2,-1,223:4,-1:6,223:7" +
",-1:4,223:6,149,223:27,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:9,150,22" +
"3:24,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:3,199,223:30,-1:4,174,223:" +
"2,-1,223:4,-1:6,223:7,-1:4,223:7,200,223:26,-1:4,174,223:2,-1,223:4,-1:6,22" +
"3:7,-1:4,223:27,201,223:6,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:10,20" +
"2,223:23,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:2,226,223:31,-1:4,174," +
"223:2,-1,223:4,-1:6,223:7,-1:4,223:34,-1:4,174,223:2,-1,223:4,-1:6,203,223:" +
"6,-1:4,223:31,204,223:2,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:13,205," +
"223:20,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:6,227,223:27,-1:4,174,22" +
"3:2,-1,223:4,-1:6,223:7,-1:4,223:34,-1:4,174,223:2,-1,223:4,-1:6,223,206,22" +
"3:5,-1:4,223:9,207,223:24,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:8,209" +
",223:25,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:12,210,223:21,-1:4,174," +
"223:2,-1,223:4,-1:6,223:7,-1:4,223:11,212,223:22,-1:4,174,223:2,-1,223:4,-1" +
":6,223:7,-1:4,223:34,-1:4,174,223,213,-1,223:4,-1:6,223:7,-1:4,223:34,-1:4," +
"174,223:2,-1,223:2,214,223,-1:6,223:7,-1:4,223:20,215,223:13,-1:4,174,223:2" +
",-1,223:4,-1:6,223:7,-1:4,223:23,216,223:10,-1:4,174,223:2,-1,223:4,-1:6,22" +
"3:7,-1:4,223:2,151,223:31,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:34,-1" +
":4,174,223,152,-1,223:4,-1:6,223:7,-1:4,223:34,-1:4,174,228,223,-1,223:4,-1" +
":6,223:7,-1:4,223:6,153,223:27,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:" +
"34,-1:4,174,223:2,-1,223:2,154,223,-1:6,223:7,-1:4,223:34,-1:4,174,223:2,-1" +
",223,229,223:2,-1:6,223:7,-1:4,223:15,155,223:18,-1:4,174,223:2,-1,223:4,-1" +
":6,223:7,-1:4,223:34,-1:4,174,223:2,-1,223:4,-1:6,156,223:6,-1:4,223:8,157," +
"223:25,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:18,158,223:15,-1:4,174,2" +
"23:2,-1,223:4,-1:6,223:7,-1:4,223:34,-1:4,174,223:2,-1,223:4,-1:6,223,159,2" +
"23:5,-1:4,223:11,160,223:22,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:15," +
"161,223:18,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:18,162,223:15,-1:4,1" +
"74,223:2,-1,223:4,-1:6,223:7,-1:4,223:29,219,223:4,-1:4,174,223:2,-1,223:4," +
"-1:6,223:7,-1:4,223:33,220,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:29,1" +
"63,223:4,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:33,164,-1:4,174,223:2," +
"-1,223:4,-1:6,223:7,-1:4,223:34,-1:4,174,223:2,-1,223:4,-1:6,165,223:6,-1:4" +
",223:34,-1:4,174,223:2,-1,223:4,-1:6,223,166,223:5,-1:4,223:2,167,223:31,-1" +
":4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:6,168,223:27,-1:4,174,223:2,-1,22" +
"3:4,-1:6,223:7,-1:4,223:3,208,223:30,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:" +
"4,223:7,211,223:26,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:20,217,223:1" +
"3,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:23,218,223:10,-1:4,174,223:2," +
"-1,223:4,-1:6,223:7,-1:4,223:34,-1:4,174,221,223,-1,223:4,-1:6,223:7,-1:4,2" +
"23:34,-1:4,174,223:2,-1,223,222,223:2,-1:6,223:7,-1:4,223:34,-1:4,174,223,1" +
"75,-1,223:4,-1:6,223:7,-1:4,223:5,176,223:28,-1:4,174,223:2,-1,223:4,-1:6,2" +
"23:7,-1:4,223:34,-1:4,174,223:2,-1,223:2,177,223,-1:6,223:7,-1:4,223:15,180" +
",223:18,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:18,181,223:15,-1:4,174," +
"223:2,-1,223:4,-1:6,223:7,-1:4,223:3,182,223:11,183,223:18,-1:4,174,223:2,-" +
"1,223:4,-1:6,223:7,-1:4,223:18,184,223:15,-1:4,174,223:2,-1,223:4,-1:6,223:" +
"7,-1:4,223:3,187,223:30,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:3,188,2" +
"23:30,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:7,191,223:26,-1:4,174,223" +
":2,-1,223:4,-1:6,223:7,-1:4,223:7,192,223:26,-1:4,174,223:2,-1,223:4,-1:6,2" +
"23:7,-1:4,223:3,193,223:30,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:2,22" +
"4,223:31,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:15,194,223:18,-1:4,174" +
",223:2,-1,223:4,-1:6,223:7,-1:4,223:7,195,223:26,-1:4,174,223:2,-1,223:4,-1" +
":6,223:7,-1:4,223:6,225,223:27,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:4,223:" +
"18,196,223:15,-1:4,174,223:2,-1,223:4,-1:6,223:7,-1:3");

	public java_cup.runtime.Symbol next_token ()
		throws java.io.IOException {
		int yy_lookahead;
		int yy_anchor = YY_NO_ANCHOR;
		int yy_state = yy_state_dtrans[yy_lexical_state];
		int yy_next_state = YY_NO_STATE;
		int yy_last_accept_state = YY_NO_STATE;
		boolean yy_initial = true;
		int yy_this_accept;

		yy_mark_start();
		yy_this_accept = yy_acpt[yy_state];
		if (YY_NOT_ACCEPT != yy_this_accept) {
			yy_last_accept_state = yy_state;
			yy_mark_end();
		}
		while (true) {
			if (yy_initial && yy_at_bol) yy_lookahead = YY_BOL;
			else yy_lookahead = yy_advance();
			yy_next_state = YY_F;
			yy_next_state = yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];
			if (YY_EOF == yy_lookahead && true == yy_initial) {

  return new Symbol(sym.EOF, null);
			}
			if (YY_F != yy_next_state) {
				yy_state = yy_next_state;
				yy_initial = false;
				yy_this_accept = yy_acpt[yy_state];
				if (YY_NOT_ACCEPT != yy_this_accept) {
					yy_last_accept_state = yy_state;
					yy_mark_end();
				}
			}
			else {
				if (YY_NO_STATE == yy_last_accept_state) {
					throw (new Error("Lexical Error: Unmatched Input."));
				}
				else {
					yy_anchor = yy_acpt[yy_last_accept_state];
					if (0 != (YY_END & yy_anchor)) {
						yy_move_end();
					}
					yy_to_mark();
					switch (yy_last_accept_state) {
					case 1:
						
					case -2:
						break;
					case 2:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -3:
						break;
					case 3:
						{
  return new Symbol(sym.LESS_THAN, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -4:
						break;
					case 4:
						{
  return new Symbol(sym.EQUAL, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -5:
						break;
					case 5:
						{
  return new Symbol(sym.RPAREN, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -6:
						break;
					case 6:
						{
  return new Symbol(sym.GREATER_THAN, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -7:
						break;
					case 7:
						{
  return new Symbol(sym.CONSTANT, new Integer(Integer.parseInt(yytext())));
  //new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -8:
						break;
					case 8:
						{ }
					case -9:
						break;
					case 9:
						{
  return new Symbol(sym.PERIOD, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -10:
						break;
					case 10:
						{
  return new Symbol(sym.COMMA, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -11:
						break;
					case 11:
						{
  return new Symbol(sym.COLON, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -12:
						break;
					case 12:
						{
  return new Symbol(sym.LPAREN, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -13:
						break;
					case 13:
						{
  return new Symbol(sym.ARITHMETIC_OP, new String(yytext()));
}
					case -14:
						break;
					case 14:
						{
  return new Symbol(sym.error, null);
}
					case -15:
						break;
					case 15:
						{
  return new Symbol(sym.OR, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -16:
						break;
					case 16:
						{
  return new Symbol(sym.AS, new String(yytext()));
}
					case -17:
						break;
					case 17:
						{
  return new Symbol(sym.LESS_EQUAL, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -18:
						break;
					case 18:
						{
  return new Symbol(sym.NOT_EQUAL, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -19:
						break;
					case 19:
						{
  return new Symbol(sym.GREATER_EQUAL, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -20:
						break;
					case 20:
						{
  yybegin(COMMENTS);
}
					case -21:
						break;
					case 21:
						{
  return new Symbol(sym.FOR, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -22:
						break;
					case 22:
						{
  return new Symbol(sym.AND, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -23:
						break;
					case 23:
						{
  return new Symbol(sym.FROM, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -24:
						break;
					case 24:
						{
  return new Symbol(sym.ONE_SHOT, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -25:
						break;
					case 25:
						{
  return new Symbol(sym.SIZE, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -26:
						break;
					case 26:
						{
  return new Symbol(sym.INTO, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -27:
						break;
					case 27:
						{
  return new Symbol(sym.WHERE, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -28:
						break;
					case 28:
						{
  return new Symbol(sym.EPOCH, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -29:
						break;
					case 29:
						{
  return new Symbol(sym.QUERY_STRING, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -30:
						break;
					case 30:
						{
  return new Symbol(sym.SELECT, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -31:
						break;
					case 31:
						{
  return new Symbol(sym.DURATION, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -32:
						break;
					case 32:
						{
  return new Symbol(sym.BUFFER, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -33:
						break;
					case 33:
						{
  return new Symbol(sym.ONEVENT, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -34:
						break;
					case 34:
						{
  return new Symbol(sym.DROPALL, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -35:
						break;
					case 35:
						{
  return new Symbol(sym.GROUP_BY, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -36:
						break;
					case 36:
						{
  return new Symbol(sym.ACTION, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -37:
						break;
					case 37:
						{
  return new Symbol(sym.CREATE, new TokenValue(yytext(), yyline, yychar, sourceFilename));
}
					case -38:
						break;
					case 38:
						{
}
					case -39:
						break;
					case 39:
						{
  yybegin(YYINITIAL);
}
					case -40:
						break;
					case 41:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -41:
						break;
					case 42:
						{
  return new Symbol(sym.ARITHMETIC_OP, new String(yytext()));
}
					case -42:
						break;
					case 44:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -43:
						break;
					case 46:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -44:
						break;
					case 48:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -45:
						break;
					case 50:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -46:
						break;
					case 52:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -47:
						break;
					case 54:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -48:
						break;
					case 56:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -49:
						break;
					case 58:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -50:
						break;
					case 60:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -51:
						break;
					case 62:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -52:
						break;
					case 64:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -53:
						break;
					case 66:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -54:
						break;
					case 68:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -55:
						break;
					case 70:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -56:
						break;
					case 72:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -57:
						break;
					case 74:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -58:
						break;
					case 76:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -59:
						break;
					case 78:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -60:
						break;
					case 80:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -61:
						break;
					case 82:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -62:
						break;
					case 84:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -63:
						break;
					case 86:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -64:
						break;
					case 88:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -65:
						break;
					case 90:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -66:
						break;
					case 92:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -67:
						break;
					case 94:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -68:
						break;
					case 96:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -69:
						break;
					case 98:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -70:
						break;
					case 100:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -71:
						break;
					case 102:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -72:
						break;
					case 104:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -73:
						break;
					case 106:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -74:
						break;
					case 108:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -75:
						break;
					case 110:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -76:
						break;
					case 112:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -77:
						break;
					case 114:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -78:
						break;
					case 116:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -79:
						break;
					case 118:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -80:
						break;
					case 120:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -81:
						break;
					case 122:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -82:
						break;
					case 130:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -83:
						break;
					case 135:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -84:
						break;
					case 136:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -85:
						break;
					case 137:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -86:
						break;
					case 138:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -87:
						break;
					case 139:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -88:
						break;
					case 140:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -89:
						break;
					case 141:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -90:
						break;
					case 142:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -91:
						break;
					case 143:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -92:
						break;
					case 144:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -93:
						break;
					case 145:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -94:
						break;
					case 146:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -95:
						break;
					case 147:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -96:
						break;
					case 148:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -97:
						break;
					case 149:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -98:
						break;
					case 150:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -99:
						break;
					case 151:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -100:
						break;
					case 152:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -101:
						break;
					case 153:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -102:
						break;
					case 154:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -103:
						break;
					case 155:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -104:
						break;
					case 156:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -105:
						break;
					case 157:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -106:
						break;
					case 158:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -107:
						break;
					case 159:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -108:
						break;
					case 160:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -109:
						break;
					case 161:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -110:
						break;
					case 162:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -111:
						break;
					case 163:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -112:
						break;
					case 164:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -113:
						break;
					case 165:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -114:
						break;
					case 166:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -115:
						break;
					case 167:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -116:
						break;
					case 168:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -117:
						break;
					case 169:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -118:
						break;
					case 170:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -119:
						break;
					case 171:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -120:
						break;
					case 172:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -121:
						break;
					case 173:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -122:
						break;
					case 174:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -123:
						break;
					case 175:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -124:
						break;
					case 176:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -125:
						break;
					case 177:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -126:
						break;
					case 178:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -127:
						break;
					case 179:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -128:
						break;
					case 180:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -129:
						break;
					case 181:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -130:
						break;
					case 182:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -131:
						break;
					case 183:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -132:
						break;
					case 184:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -133:
						break;
					case 185:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -134:
						break;
					case 186:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -135:
						break;
					case 187:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -136:
						break;
					case 188:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -137:
						break;
					case 189:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -138:
						break;
					case 190:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -139:
						break;
					case 191:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -140:
						break;
					case 192:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -141:
						break;
					case 193:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -142:
						break;
					case 194:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -143:
						break;
					case 195:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -144:
						break;
					case 196:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -145:
						break;
					case 197:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -146:
						break;
					case 198:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -147:
						break;
					case 199:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -148:
						break;
					case 200:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -149:
						break;
					case 201:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -150:
						break;
					case 202:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -151:
						break;
					case 203:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -152:
						break;
					case 204:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -153:
						break;
					case 205:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -154:
						break;
					case 206:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -155:
						break;
					case 207:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -156:
						break;
					case 208:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -157:
						break;
					case 209:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -158:
						break;
					case 210:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -159:
						break;
					case 211:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -160:
						break;
					case 212:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -161:
						break;
					case 213:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -162:
						break;
					case 214:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -163:
						break;
					case 215:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -164:
						break;
					case 216:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -165:
						break;
					case 217:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -166:
						break;
					case 218:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -167:
						break;
					case 219:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -168:
						break;
					case 220:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -169:
						break;
					case 221:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -170:
						break;
					case 222:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -171:
						break;
					case 223:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -172:
						break;
					case 224:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -173:
						break;
					case 225:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -174:
						break;
					case 226:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -175:
						break;
					case 227:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -176:
						break;
					case 228:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -177:
						break;
					case 229:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -178:
						break;
					case 230:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -179:
						break;
					case 231:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -180:
						break;
					case 232:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -181:
						break;
					case 233:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -182:
						break;
					case 234:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -183:
						break;
					case 235:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -184:
						break;
					case 236:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -185:
						break;
					case 237:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -186:
						break;
					case 238:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -187:
						break;
					case 239:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -188:
						break;
					case 240:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -189:
						break;
					case 241:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -190:
						break;
					case 242:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -191:
						break;
					case 243:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -192:
						break;
					case 244:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -193:
						break;
					case 245:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -194:
						break;
					case 246:
						{
  return new Symbol(sym.NAME, new String(yytext()));
}
					case -195:
						break;
					default:
						yy_error(YY_E_INTERNAL,false);
					case -1:
					}
					yy_initial = true;
					yy_state = yy_state_dtrans[yy_lexical_state];
					yy_next_state = YY_NO_STATE;
					yy_last_accept_state = YY_NO_STATE;
					yy_mark_start();
					yy_this_accept = yy_acpt[yy_state];
					if (YY_NOT_ACCEPT != yy_this_accept) {
						yy_last_accept_state = yy_state;
						yy_mark_end();
					}
				}
			}
		}
	}
}
