// $Id: AttrGlobalM.nc,v 1.2.4.5 2003/08/26 09:08:13 cssharp Exp $

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */

/* 
 * Authors:  Wei Hong
 *           Intel Research Berkeley Lab
 * Date:     7/1/2002
 *
 */

/**
 * @author Wei Hong
 * @author Intel Research Berkeley Lab
 */

includes AM;

// component to expose certain global variables as attributes
module AttrPositionM
{
	provides interface StdControl;
	uses
	{
//benchmark use: +++++++++++++++++++++++++++++++++++
    		interface AttrRegister as PosiAttrX;
    		interface AttrRegister as PosiAttrY;
    //+++++++++++++++++++++++++++++++++++++++++++++++++++
	}
}
#define g_pos_x 0xaa55
#define g_pos_y 0x55aa
implementation
{

	command result_t StdControl.init()
	{
	 //benchmark position needed++++++++++++++++++++++++++++++++++++++

		 call PosiAttrX.registerAttr("posi_x", UINT16, 2);// != SUCCESS
		//	return FAIL;
		 call PosiAttrY.registerAttr("posi_y", UINT16, 2);// != SUCCESS)
		//	return FAIL;
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     			    
 
		return SUCCESS;
	}

	command result_t StdControl.start()
	{
		return SUCCESS;
	}

	command result_t StdControl.stop()
	{
		return SUCCESS;
	}

	//benchmark position use:++++++++++++++++++++++++++++++++++++++++++++++++++
	event result_t PosiAttrX.startAttr()
	{
		return call PosiAttrX.startAttrDone();
	}

	event result_t PosiAttrX.getAttr(char *name, char *resultBuf, SchemaErrorNo *errorNo)
	{
		uint8_t marker[] ={"whj_position_xco"};
		*errorNo = SCHEMA_RESULT_READY;
		
		*(uint16_t*)resultBuf = *(uint16_t*)(marker+14);
		return SUCCESS;
	}
	 event result_t PosiAttrX.setAttr(char *name, char *resultBuf)
	{

		return SUCCESS;
	}
	
	event result_t PosiAttrY.startAttr()
	{
		return call PosiAttrY.startAttrDone();
	}
	event result_t PosiAttrY.getAttr(char *name, char *resultBuf, SchemaErrorNo *errorNo)
	{
		uint8_t marker[] ={"whj_position_yco"};
		*errorNo = SCHEMA_RESULT_READY;
		*(uint16_t*)resultBuf = *(uint16_t*)(marker+14);
		return SUCCESS;
	}

  event result_t PosiAttrY.setAttr(char *name, char *resultBuf)
	{

		return SUCCESS;
	}
 //++++++++++++++++++++++++++++++++++++++++++++++++++

 
}
