// $Id: AggOperatorConf.nc,v 1.4.4.3 2003/09/03 23:14:04 smadden Exp $

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */
/**
 * This configuration wires AggOperator to individual aggregates
 */
 
/*
* Modifications:
*
* Copyright (c) 2006, The Hong Kong University of Science and Technology (HKUST)
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions 
* are met:
*
*   * Redistributions of source code must retain the above copyright notice, 
*     this list of conditions,the authors and the following disclaimer.
*   * Redistributions in binary form must reproduce the above copyright notice,
*     this list of conditions,the authors and the following disclaimer in
*     the documentation and/or other materials provided with the distribution.
*   * Neither the name of the university nor the names of its 
*     contributors may be used to endorse or promote products derived from 
*     this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
* POSSIBILITY OF SUCH DAMAGE.
*
* Author: Wenwei Xue (wwxue@cs.ust.hk)
* Date last modified:  03/15/06
*/
 
#ifndef NETWORK_MODULE
#define NETWORK_MODULE	NetworkC
#endif

includes Aggregates;

configuration AggOperatorConf {

provides {
    interface Operator;
    command TinyDBError addResults(QueryResult *qr, ParsedQuery *q, Expr *e);
    command TinyDBError finalizeAggExpr(QueryResult *qr, ParsedQueryPtr q, Expr *e, char *result_buf);
    command short getGroupNoFromQr(QueryResult *qr);
  }
}

implementation {
	components AggOperator, TinyAlloc, TupleRouterM, Tuple, ParsedQuery, ExprEvalC,
			   NoLeds, QueryResult;
	components AggregateUseM, 
	                   //MaxM, MinM, CountM, SumM, AvgM, 
	                   //ExpAvgM, WinMinM, WinMaxM, WinCountM, WinSumM, WinAvgM,
			   ContourMapM, LedsC;
#ifdef kFANCY_AGGS
	components WinRandM, AdpDeltaM, DeltaM, TrendM, RandomLFSR, NETWORK_MODULE;
#endif
			   
	Operator = AggOperator;
	addResults = AggOperator.addResults;
	finalizeAggExpr = AggOperator.finalizeAggExpr;
	getGroupNoFromQr = AggOperator.getGroupNoFromQr;
	
	AggOperator.MemAlloc -> TinyAlloc;
	AggOperator.QueryProcessor -> TupleRouterM;
	AggOperator.TupleIntf -> Tuple;
 	AggOperator.ParsedQueryIntf -> ParsedQuery;
	AggOperator.ExprEval -> ExprEvalC;
	AggOperator.Leds -> NoLeds;
	AggOperator.QueryResultIntf -> QueryResult;
	AggOperator.signalError -> TupleRouterM.signalError;
	
	//hook up aggregates
	AggOperator.AggregateUse -> AggregateUseM;
	
	//maybe we need a config for AggregateUse?
    /*MaxM.Aggregate <- AggregateUseM.Agg[kMAX];
    MinM.Aggregate <- AggregateUseM.Agg[kMIN];
    CountM.Aggregate <- AggregateUseM.Agg[kCOUNT];
    SumM.Aggregate <- AggregateUseM.Agg[kSUM];
    AvgM.Aggregate <- AggregateUseM.Agg[kAVG];  
    ExpAvgM.Aggregate <- AggregateUseM.Agg[kEXP_AVG];
    WinMinM.Aggregate <- AggregateUseM.Agg[kWIN_MIN];
    WinMaxM.Aggregate <- AggregateUseM.Agg[kWIN_MAX];
    WinCountM.Aggregate <- AggregateUseM.Agg[kWIN_COUNT];
    WinSumM.Aggregate <- AggregateUseM.Agg[kWIN_SUM];
    WinAvgM.Aggregate <- AggregateUseM.Agg[kWIN_AVG];*/
    
    ContourMapM.Aggregate <- AggregateUseM.Agg[kCONTOUR_MAP];
    ContourMapM.Leds -> LedsC;
#ifdef kFANCY_AGGS
	WinRandM.Aggregate <- AggregateUseM.Agg[kWIN_RAND];
	AdpDeltaM.Aggregate <- AggregateUseM.Agg[kADP_DELTA];
	DeltaM.Aggregate <- AggregateUseM.Agg[kDELTA];
	TrendM.Aggregate <- AggregateUseM.Agg[kTREND];
	
    	WinRandM.Random -> RandomLFSR;
	AdpDeltaM.NetworkMonitor -> NETWORK_MODULE;
#endif

}
	
