// $Id: AggregateUseM.nc,v 1.4.4.3 2003/08/26 09:08:14 cssharp Exp $

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */
/**
 * Currently, if you want to add a custom aggregate, you have to edit this file,
 * as well as AggOperatorConf.nc
 *
 * Author:	Eugene Shvets
 * @author Eugene Shvets
 */
 
/*
* Modifications:
*
* Copyright (c) 2006, The Hong Kong University of Science and Technology (HKUST)
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions 
* are met:
*
*   * Redistributions of source code must retain the above copyright notice, 
*     this list of conditions,the authors and the following disclaimer.
*   * Redistributions in binary form must reproduce the above copyright notice,
*     this list of conditions,the authors and the following disclaimer in
*     the documentation and/or other materials provided with the distribution.
*   * Neither the name of the university nor the names of its 
*     contributors may be used to endorse or promote products derived from 
*     this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
* POSSIBILITY OF SUCH DAMAGE.
*
* Author: Wenwei Xue (wwxue@cs.ust.hk)
* Date last modified:  03/15/06
*/

module AggregateUseM {
	provides {
		interface AggregateUse;
	}
	
	uses { // Aggs are hooked up in AggregateOperatorConf now,
	       // but we probably want to make wiring of aggregates self-contained
		interface Aggregate as Agg[uint8_t id];
    }
}

implementation {

	command result_t AggregateUse.merge(uint8_t id, char *destdata, char *mergedata, ParamList *params, ParamVals *paramValues) {
		return call Agg.merge[id]( destdata, mergedata, params, paramValues);
	}
	
	//we'll probably get rid of this later
	command result_t AggregateUse.update(uint8_t id, char *destdata, char* value, ParamList *params, ParamVals *paramValues) {
		return call Agg.update[id]( destdata, value, params, paramValues);
	}

	//doubles as startEpoch right now? might separate the two
	command result_t AggregateUse.init(uint8_t id, char *data, ParamList *params, ParamVals *paramValues, bool isFirstTime){
		return call Agg.init[id]( data, params, paramValues, isFirstTime);
	}

	command uint16_t AggregateUse.stateSize(uint8_t id, ParamList *params, ParamVals *paramValues) {
		return call Agg.stateSize[id](params,paramValues);
	}

	command bool AggregateUse.hasData(uint8_t id, char *data, ParamList *params, ParamVals *paramValues) {
		return call Agg.hasData[id](data, params, paramValues);
	}

	command TinyDBError AggregateUse.finalize(uint8_t id, char *data, char *result_buf, ParamList *params, ParamVals *paramValues) {
		return call Agg.finalize[id](data, result_buf, params, paramValues);
	}
	
	/*command AggregateProperties AggregateUse.getProperties(uint8_t id) {
		return call Agg.getProperties[id]();
	}*/
	
	/**
	 * Default implementation of Aggregate interface for id's that are not wired
	 */
	default command result_t Agg.merge[uint8_t id]
	(char *destdata, char *mergedata, ParamList *params, ParamVals *paramValues) {
		return SUCCESS;
	}
	
	default command result_t Agg.update[uint8_t id]
	(char *destdata, char* value, ParamList *params, ParamVals *paramValues) {
		return SUCCESS;
	}
	
	default command result_t Agg.init[uint8_t id]
	(char *data, ParamList *params, ParamVals *paramValues, bool isFirstTime){
		return SUCCESS;
	}
	
	default command uint16_t Agg.stateSize[uint8_t id]
	(ParamList *params, ParamVals *paramValues) {
		return 0;
	}
	
	default command bool Agg.hasData[uint8_t id]
	(char *data, ParamList *params, ParamVals *paramValues) {
		return FALSE;
	}
	
	default command TinyDBError Agg.finalize[uint8_t id]
	(char *data, char *result_buf, ParamList *params, ParamVals *paramValues) {
		return err_NoError;
	}
	
	/*default command AggregateProperties Agg.getProperties[uint8_t id]() {
		return 0;
	}*/
}

